const { EmbedBuilder, Events, AuditLogEvent } = require('discord.js');
const theme = require('../../../embedConfig.json');
const Audit_Log = require('../../Schemas.js/auditlog');
const log_actions = require("../../Schemas.js/logactions");
const token = require("../../../encrypt").token(5);

module.exports = async (client) => {
    client.on(Events.GuildMemberUpdate, async (oldMember, newMember) => {
        if (oldMember.isCommunicationDisabled() && !newMember.isCommunicationDisabled()) {
            const auditEmbed = new EmbedBuilder()
                .setColor(theme.theme)
                .setTitle('Timeout Removed')
                .setDescription(`Member: ${newMember.user.tag}`)
                .setTimestamp()
                .setFooter({ text: 'Nexus Audit Log System' });

            const data = await Audit_Log.findOne({ Guild: newMember.guild.id });
            if (!data) return;

            const auditChannel = await client.channels.fetch(data.Untimeout).catch(() => null);
            if (auditChannel) {
                await auditChannel.send({ embeds: [auditEmbed] }).catch(() => {});
            }
        }
    });
};
